<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Image Resizer & KB Reducer - MyCSP Pro</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

    <header>
        <div class="logo-area">
            <div class="logo-icon">🖼️</div>
            <div class="logo-text">MyCSP <span>Pro</span></div>
        </div>
        <a href="https://mycsp.online" class="back-btn">← Back to Home</a>
    </header>

    <main>
        <form id="imageForm" enctype="multipart/form-data">
            <div class="tool-grid">
                <!-- Left Side: Upload & Preview -->
                <div>
                    <div class="upload-card">
                        <div style="font-size:40px; margin-bottom:10px;">☁️</div>
                        <h3 id="fileName">Click to Upload Image</h3>
                        <p style="color:#94a3b8; font-size:12px;">Supports JPG, PNG, WEBP</p>
                        <input type="file" name="image" id="fileInput" class="file-input" accept="image/*" required>
                    </div>

                    <!-- Original Preview -->
                    <div id="originalPreview" class="preview-box">
                        <p style="color:#fff;">Original Image</p>
                        <img id="origImgTag" class="preview-img" src="">
                        <div class="stats" id="origStats"></div>
                    </div>
                </div>

                <!-- Right Side: Controls -->
                <div class="controls-card">
                    <div class="section-title">Settings (CSP Optimized)</div>

                    <!-- Option 1: Reduce KB -->
                    <div class="input-group">
                        <label>Target Size (KB) - <small style="color:#ec4899">Leave empty if not needed</small></label>
                        <input type="number" name="target_kb" class="form-control" placeholder="e.g. 20, 50, 100">
                    </div>

                    <!-- Option 2: Resize Dimensions -->
                    <div class="input-group">
                        <label>New Dimensions (Pixels)</label>
                        <div class="form-row">
                            <input type="number" name="width" class="form-control" placeholder="Width (px)">
                            <input type="number" name="height" class="form-control" placeholder="Height (px)">
                        </div>
                    </div>

                    <!-- Option 3: Format & Rotate -->
                    <div class="input-group">
                        <div class="form-row">
                            <div style="flex:1;">
                                <label>Convert Format</label>
                                <select name="format" class="form-control">
                                    <option value="original">Keep Original</option>
                                    <option value="jpg">JPG (Best for Forms)</option>
                                    <option value="png">PNG (High Quality)</option>
                                    <option value="webp">WebP</option>
                                </select>
                            </div>
                            <div style="flex:1;">
                                <label>Rotate</label>
                                <select name="rotate" class="form-control">
                                    <option value="0">No Rotation</option>
                                    <option value="90">90° Clockwise</option>
                                    <option value="180">180° Upside Down</option>
                                    <option value="270">90° Counter-Clockwise</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="btn-action" id="processBtn">Process Image</button>
                    <div id="loading" style="display:none; text-align:center; margin-top:10px; color:#ec4899;">Processing... Please wait...</div>
                </div>
            </div>
        </form>

        <!-- Final Result Section -->
        <div id="resultSection" class="preview-box" style="background:rgba(16, 185, 129, 0.1); border:1px solid #10b981; padding:20px; border-radius:12px; margin-top:30px;">
            <h3 style="color:#10b981;">Successfully Processed!</h3>
            <div class="stats" id="newStats" style="font-size:16px; margin:10px 0;"></div>
            <img id="finalImgTag" class="preview-img" src="">
            <br>
            <a id="downloadBtn" href="#" class="btn-action" style="display:inline-block; width:auto; padding:10px 30px; text-decoration:none;">Download Image</a>
        </div>

    </main>

    <footer>
        <p>&copy; 2025 <strong>MyCSP</strong>. All rights reserved.</p>
        <p style="margin-top:5px; font-size: 12px;">Powered by <span class="powered-by">Aniya Foundation</span></p>
    </footer>

    <!-- JavaScript to Handle Ajax without Reload -->
    <script>
        const fileInput = document.getElementById('fileInput');
        const fileName = document.getElementById('fileName');
        const origImgTag = document.getElementById('origImgTag');
        const originalPreview = document.getElementById('originalPreview');
        const origStats = document.getElementById('origStats');

        // File Select Preview
        fileInput.addEventListener('change', function() {
            if (this.files && this.files[0]) {
                let file = this.files[0];
                fileName.innerText = file.name;
                
                // Show Original Preview
                let reader = new FileReader();
                reader.onload = function(e) {
                    origImgTag.src = e.target.result;
                    originalPreview.style.display = 'block';
                    origStats.innerText = "Size: " + (file.size / 1024).toFixed(2) + " KB";
                }
                reader.readAsDataURL(file);
            }
        });

        // Handle Form Submit
        document.getElementById('imageForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const btn = document.getElementById('processBtn');
            const loading = document.getElementById('loading');
            
            btn.style.display = 'none';
            loading.style.display = 'block';
            document.getElementById('resultSection').style.display = 'none';

            fetch('process.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                loading.style.display = 'none';
                btn.style.display = 'block';

                if(data.success) {
                    document.getElementById('finalImgTag').src = data.url;
                    document.getElementById('downloadBtn').href = 'download.php?file=' + data.filename;
                    document.getElementById('newStats').innerText = "New Size: " + data.size;
                    document.getElementById('resultSection').style.display = 'block';
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                loading.style.display = 'none';
                btn.style.display = 'block';
                alert("Something went wrong with the server.");
            });
        });
    </script>
</body>
</html>